package doABC;

import java.nio.ByteBuffer;
import java.util.*;
import FlashReader.*;

public class OptionInfo extends SwfTools{
	
	private int id;
	private int start;
	private int end;
	//struktury
	private int option_count;
	private ArrayList<OptionDetail> option_detail = new ArrayList<OptionDetail>();
	

	public OptionInfo(ByteBuffer bbuf, int param_count,AbcFile abc){
		super();
		option_info(bbuf,param_count,abc);
		abc.ENoption_info.add(this);
		id = abc.ENoption_info.size()-1;
	}
	
	/**
	 * z dokumentacji avm2 str. 27
	 */
	private void option_info(ByteBuffer bbuf, int param_count,AbcFile abc){
		try{
		start = bbuf.position();
		
		option_count = unsigned30int(bbuf);
		
		for (int i=0;i<option_count;i++ )
				option_detail.add(new OptionDetail(bbuf));
	
		} catch (Exception e) {e.printStackTrace();}
		end = bbuf.position()-1;
	}
	
	public ArrayList<Byte> toByteCode(){
		ArrayList<Byte> result = new ArrayList<Byte>();

			for ( byte b: getUI32(option_count))
				result.add(b);	

			for (int i=0;i<option_detail.size();i++){
				for ( byte b: option_detail.get(i).toByteCode())
					result.add(b);	
			}

		return result;
	}
	
	//getters
	
	public ArrayList<OptionDetail> getOption_detail() {
		return option_detail;
	}
	
	//tostrings
	
	public String String(){
		StringBuffer wynik = new StringBuffer();
		
		wynik.append( ">" + start+"\n" );
		
		wynik.append( "option_count: " + option_count+"\n" );
			
		wynik.append( "<" + end+"\n" );		
		
		return wynik.toString();

	}

	public String toString(){
		String wynik ="";
		wynik+="option_info " + "id " + id + " "  +start+ " - " + end;
		return wynik;
	}
	public String toString2(){
		String wynik ="";
		wynik+="option_info";
		return wynik;
	}
	
}
